using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Teapot
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Model czajnik;
        //Texture2D nefryt;

        Matrix World,View,Projection;

        Effect efekt;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            base.Initialize();

            World = Matrix.Identity;
            View = Matrix.CreateLookAt(2.5f * Vector3.UnitZ, Vector3.Zero, Vector3.Up);
            Projection = Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver2, GraphicsDevice.Viewport.AspectRatio, 1, 100);
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            //nefryt = Content.Load<Texture2D>("Nefryt_256x256");

            efekt = Content.Load<Effect>("efekt1");
            efekt.Parameters["WVP"].SetValue(World * View * Projection);
            efekt.Parameters["World"].SetValue(World);

            czajnik = Content.Load<Model>("teapot");
            
            foreach (ModelMesh siatka in czajnik.Meshes)
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {                    
                    czescSiatki.Effect=efekt;
                }
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            World *= Matrix.CreateRotationY(0.01f);            
            efekt.Parameters["WVP"].SetValue(World * View * Projection);
            efekt.Parameters["World"].SetValue(World);

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice gd = this.GraphicsDevice;

            gd.Clear(Color.Black);

            foreach (ModelMesh siatka in czajnik.Meshes)
            {
                foreach (Effect efekt in siatka.Effects)
                    siatka.Draw();
            }

            /*
            efekt.Begin();
            foreach (EffectPass przebieg in efekt.CurrentTechnique.Passes)
            {
                przebieg.Begin();

                foreach (ModelMesh siatka in czajnik.Meshes)
                {
                    foreach (ModelMeshPart meshpart in siatka.MeshParts)
                    {
                        gd.VertexDeclaration = meshpart.VertexDeclaration;
                        gd.Vertices[0].SetSource(siatka.VertexBuffer, meshpart.StreamOffset, meshpart.VertexStride);
                        gd.Indices = siatka.IndexBuffer;
                        gd.DrawIndexedPrimitives(PrimitiveType.TriangleList, meshpart.BaseVertex, 0, meshpart.NumVertices, meshpart.StartIndex, meshpart.PrimitiveCount);                        
                    }
                }

                przebieg.End();
            }
            efekt.End();
            */
            
            base.Draw(gameTime);
        }
    }
}
